<?php

namespace App\Models\Reference;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Accreditation extends Model 
{

    protected $table = 'accreditations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function services()
    {
        return $this->belongsToMany('Service', 'service_accreditation', 'accreditation_id', 'service_id')->withTimestamps();
    }

}